//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//
// TypeTesterDlg.h : plik nagwka
//

#pragma once
#include "afxwin.h"

const UINT WM_COMINTEROP_COLORCHANGED = (WM_USER + 101);
const UINT WM_COMINTEROP_DATECHANGED = (WM_USER + 102);
const UINT WM_COMINTEROP_NAMECHANGED = (WM_USER + 103);
const UINT WM_COMINTEROP_DECIMALCHANGED = (WM_USER + 104);
const UINT WM_COMINTEROP_VARIANTCHANGED = (WM_USER + 105);
const UINT WM_COMINTEROP_ARRAYCHANGED = (WM_USER + 106);
const UINT WM_COMINTEROP_COUNTER = (WM_USER + 107);

static const int COMTYPE_SOURCE_ID = 0 ;

static const int DISPID_ONCOLORCHANGED = 1;
static const int DISPID_ONDATECHANGED = 2;
static const int DISPID_ONNAMECHANGED = 3;
static const int DISPID_ONDECIMALCHANGED = 4;
static const int DISPID_ONVARIANTCHANGED = 5;
static const int DISPID_ONARRAYCHANGED = 6;
static const int DISPID_ONCOUNTER = 7;

class CComTypeEvents;

typedef IDispEventSimpleImpl<COMTYPE_SOURCE_ID, CComTypeEvents, &dotNETCOMTypes::DIID__IComTypesEvents> ComTypeEventImpl; 

class CComTypeEvents :
	public CComObjectRoot,
    public ComTypeEventImpl
{
public:
	CComTypeEvents()
	{
		pNotifyWindow = NULL;
	}
    void FinalRelease ()
    {
    }

	void SetNotifyWindow(CWnd *pWindow) { pNotifyWindow = pWindow; }

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CComTypeEvents)
END_COM_MAP()

BEGIN_SINK_MAP(CComTypeEvents)
   SINK_ENTRY_INFO(COMTYPE_SOURCE_ID, dotNETCOMTypes::DIID__IComTypesEvents, DISPID_ONCOLORCHANGED,   OnColorChanged,   &OnColorChangedInfo)
   SINK_ENTRY_INFO(COMTYPE_SOURCE_ID, dotNETCOMTypes::DIID__IComTypesEvents, DISPID_ONDATECHANGED,    OnDateChanged,    &OnDateChangedInfo)
   SINK_ENTRY_INFO(COMTYPE_SOURCE_ID, dotNETCOMTypes::DIID__IComTypesEvents, DISPID_ONNAMECHANGED,    OnNameChanged,    &OnNameChangedInfo)
   SINK_ENTRY_INFO(COMTYPE_SOURCE_ID, dotNETCOMTypes::DIID__IComTypesEvents, DISPID_ONDECIMALCHANGED, OnDecimalChanged, &OnDecimalChangedInfo)
   SINK_ENTRY_INFO(COMTYPE_SOURCE_ID, dotNETCOMTypes::DIID__IComTypesEvents, DISPID_ONVARIANTCHANGED, OnVariantChanged, &OnVariantChangedInfo)
   SINK_ENTRY_INFO(COMTYPE_SOURCE_ID, dotNETCOMTypes::DIID__IComTypesEvents, DISPID_ONARRAYCHANGED,   OnArrayChanged,   &OnArrayChangedInfo)
   SINK_ENTRY_INFO(COMTYPE_SOURCE_ID, dotNETCOMTypes::DIID__IComTypesEvents, DISPID_ONCOUNTER,        OnCounter,        &OnCounterInfo)
END_SINK_MAP()

// _IComTypesEvents
public:
    void __stdcall OnColorChanged(OLE_COLOR varColor);
    void __stdcall OnDateChanged(DATE date);
    void __stdcall OnNameChanged(BSTR bstrName);
    void __stdcall OnDecimalChanged(DECIMAL decimal);
    void __stdcall OnVariantChanged(VARIANT varVariant);
    void __stdcall OnArrayChanged(SAFEARRAY* sa);
    void __stdcall OnCounter(long c);
private:
    static _ATL_FUNC_INFO OnColorChangedInfo ;
    static _ATL_FUNC_INFO OnDateChangedInfo ;
    static _ATL_FUNC_INFO OnNameChangedInfo ;
    static _ATL_FUNC_INFO OnDecimalChangedInfo ;
    static _ATL_FUNC_INFO OnVariantChangedInfo ;
    static _ATL_FUNC_INFO OnArrayChangedInfo ;
    static _ATL_FUNC_INFO OnCounterInfo ;
	CComPtr<IUnknown> callback;
	CWnd* pNotifyWindow;
};

// Okno dialogowe CTypeTesterDlg
class CTypeTesterDlg :
	public CDialog
{
// Tworzenie
public:
	CTypeTesterDlg(CWnd* pParent = NULL);	// standardowy konstruktor
// Dane okna dialogowego
	enum { IDD = IDD_TYPETESTER_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// Obsuga DDX/DDV


// Implementacja
protected:
	HICON m_hIcon;

	// Wygenerowane funkcje mapy wiadomoci
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()

	CEdit counterControl;
	CEdit inputColorControl;
	CEdit inputDateControl;
	CEdit inputDecimalControl;
	CEdit inputStringControl;
	CEdit inputVariantControl;
	CEdit outputColorControl;
	CEdit outputDateControl;
	CEdit outputDecimalControl;
	CEdit outputStringControl;
	CEdit outputVariantControl;
	CEdit inputArrayControl;
	CEdit outputArrayControl;
	CComboBox errorListControl;
	CEdit errorTextControl;
	afx_msg void OnColorClicked();
	afx_msg void OnDateClicked();
	afx_msg void OnDecimalClicked();
	afx_msg void OnStringClicked();
	afx_msg void OnVariantClicked();
	afx_msg void OnArrayClicked();
	afx_msg void OnEnumClicked();
	afx_msg void OnErrorClicked();
	afx_msg void OnErrorSelectChanged();
	afx_msg void OnDestroy();
	afx_msg LONG OnCounter(UINT wParam, LONG lParam);
	afx_msg LONG OnColorChanged(UINT wParam, LONG lParam);
	afx_msg LONG OnDateChanged(UINT wParam, LONG lParam);
	afx_msg LONG OnNameChanged(UINT wParam, LONG lParam);
	afx_msg LONG OnDecimalChanged(UINT wParam, LONG lParam);
	afx_msg LONG OnVariantChanged(UINT wParam, LONG lParam);
	afx_msg LONG OnArrayChanged(UINT wParam, LONG lParam);

	CComPtr<dotNETCOMTypes::IComTypes> comTypes;
	CComObject<CComTypeEvents> *pNotify;
	LPSAFEARRAY pSafeArray;
};
